//
//	Common include file
//
//        Copyright (c) 2002 Jim Peters <http://uazu.net/>.  Released
//        under the GNU GPL version 2 as published by the Free
//        Software Foundation.  See the file COPYING for details, or
//        visit <http://www.gnu.org/copyleft/gpl.html>.
//
//	One of the target macros should be defined before this point:
//	T_LINUX, T_MINGW, or T_MSVC.
//

#define VERSION "1.0.1"
#define PROGRAM "bavsa-view"

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <errno.h>
#include <ctype.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>
#include <SDL/SDL.h>
#include <math.h>

#ifndef T_MSVC
#include <unistd.h>
#include <sys/time.h>
#endif

#ifndef M_PI
#define M_PI           3.14159265358979323846  /* pi */
#endif

#ifndef M_LN10
#define M_LN10         2.30258509299404568402  /* log_e 10 */
#endif

#ifdef T_MINGW
#ifndef isnan
#define isnan(val) _isnan(val)
#endif
#ifndef vsnprints
#define vsnprintf _vsnprintf
#endif
#endif

#ifdef T_MSVC
#define isnan(val) _isnan(val)
#define vsnprintf _vsnprintf
#endif

// Bring in header stuff (structures/etc)
#define HEADER
#include "bavsa-view.c"
#undef HEADER

#include "proto.h"

#ifndef DEBUG_ON
#define DEBUG_ON 0
#endif

#define DEBUG if (DEBUG_ON) warn
#define ALLOC(type) ((type*)Alloc(sizeof(type)))
#define ALLOC_ARR(cnt, type) ((type*)Alloc((cnt) * sizeof(type)))

// END //

